package gov.va.med.mhv.sso;

import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class FedCredFullTraitsAction extends Action {
	private static final Log logger = LogFactoryUtil.getLog(EAuthGateway.class);
	private FedCredSsoUtil fedCredSsoUtil = new FedCredSsoUtil();

	public void processFullTraitSSo(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String firstName = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.FIRST_NAME);
		String lastName = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.LAST_NAME);
		String birthDate = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.BIRTH_DATE);
		String ssn = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.FIRST_NAME);
		String middleName = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.MIDDLE_NAME);
		String gender = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.MIDDLE_NAME);
		String idType = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ID_TYPE);
		String icn = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM);
		String userProfileId = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.USER_PROFILE_ID);
		UserProfileDTO uProfile = null;
		PatientDTO patient = null;
		
		fedCredSsoUtil.logInfo(logger, "Full Traits process icn:" + icn);

		try {
			if (userProfileId != null) {
				// JAZZ Story #144874 Federated Credential - RemoteID Proofing -
				// Check to see IAM is providing Full PS traits
				String[] uProfileIds = userProfileId.split(",");
				// JAZZ Story #144874 Federated Credential - RemoteID Proofing -
				// If multiple user profile ids are provided, go to error.
				if (uProfileIds != null && uProfileIds.length > 1) {
					fedCredSsoUtil.logInfo(logger, "multiple user profile ids going to error page icn:" + icn);
					fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.MULTIPLE_ACCOUNT_ERROR_MSG);
					response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
					return;
				}
			}
		} catch (Throwable t) {
			fedCredSsoUtil.logInfo(logger, "user profile ids parsing error icn:" + icn);
		}

		try {
			Long uProfileId = null;

			try {
				if (userProfileId != null) {
					uProfileId = Long.parseLong(userProfileId);
					fedCredSsoUtil.logInfo(logger, "Retrieving user profile for user profile id:" + userProfileId);
					uProfile = fedCredSsoUtil.getUserProfileByUserProfileId(uProfileId);
				}
			} catch (Throwable t) {
				fedCredSsoUtil.logInfo(logger, "user profile id parsing error:" + userProfileId);
				uProfile = null;
			}

			if (uProfile != null) {
				fedCredSsoUtil.logInfo(logger, "uProfile != null for user profile id:" + userProfileId);

				if (fedCredSsoUtil.isUserAccountDeactivated(uProfile)) {
					fedCredSsoUtil.logInfo(logger, "isUserAccountDeactivated going to MHV Login Page user profile id:" + userProfileId);
					fedCredSsoUtil.processDeactivatedAccount(fedCredSsoUtil.getPatient(uProfile.getId()), request);
					response.sendRedirect(fedCredSsoUtil.getMhvLoginUrl());
					return;
				}
				fedCredSsoUtil.processFacilitiesUpdate(patient);
			} else {
				fedCredSsoUtil.logInfo(logger, "uProfile == null for user profile id:" + userProfileId);
				// If "NOT_FOUND" is sent in "first name", "last name" , "birth
				// date", "ssn" and "gender" , MHV will show error msg
				if (fedCredSsoUtil.isNotFound(firstName) || fedCredSsoUtil.isNotFound(lastName)
						|| fedCredSsoUtil.isNotFound(birthDate) || fedCredSsoUtil.isNotFound(ssn)) {
					fedCredSsoUtil.logInfo(logger, "Error in traits going to error page icn:" + icn);
					fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.NOT_FOUND_ERROR_MSG);
					response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
					return;
				}

				middleName = fedCredSsoUtil.processMiddleName(middleName);
				gender = fedCredSsoUtil.processGender(gender);
				ssn = fedCredSsoUtil.processSsn(ssn);

				// If SSN is not 9 digit, MHV will show error msg
				if (!fedCredSsoUtil.isSsnValid(ssn, idType)) {
					fedCredSsoUtil.logInfo(logger, "Ssn Invalid going to error page icn:" + icn);
					fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.INVALID_SSN_MSG);
					response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
					return;
				}

				// birth date is not in Date format, MHV will show error msg
				if (!fedCredSsoUtil.isDate(birthDate)) {
					fedCredSsoUtil.logInfo(logger, "DOB Invalid going to error page icn:" + icn);
					fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.INVALID_DOB_MSG);
					response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
					return;
				}

				// JAZZ Story #144874 Federated Credential - RemoteID Proofing -
				// Check for existing account with the user traits
				fedCredSsoUtil.logInfo(logger, "findUserProfile(firstName:" + firstName + ", lastName:" + lastName + ", gender:" + gender
						+ ", ssn:" + ssn + ", birthDate:" + birthDate + ") icn:"+ icn);
				uProfile = fedCredSsoUtil.findUserProfile(firstName, lastName, gender, ssn, birthDate);
				if (uProfile != null) {
					fedCredSsoUtil.logInfo(logger, "uProfile != null icn:" + icn);
					if (fedCredSsoUtil.isUserAccountDeactivated(uProfile)) {
						// JAZZ Story #144874 Federated Credential - RemoteID
						// Proofing - display an error message to the user
						// indicating
						// MHV account is inactive and to call the helpdesk for
						// assistance.
						fedCredSsoUtil.logInfo(logger, "isUserAccountDeactivated user profile id:" + userProfileId);
						fedCredSsoUtil.processDeactivatedAccount(patient, request);
						response.sendRedirect(fedCredSsoUtil.getMhvLoginUrl());
						return;
					}

					// JAZZ Story #144874 Federated Credential - RemoteID
					// Proofing - Notify User Existing MHV Account with
					// their Personal Data Already exists
					response.sendRedirect(fedCredSsoUtil.getReauthPageUrl());
					return;
				} else {
					fedCredSsoUtil.logInfo(logger, "uProfile == null icn:" + icn);
					if (fedCredSsoUtil.isICNValid(icn)) {
						fedCredSsoUtil.logInfo(logger, "calling PatientServiceDelegate().getPatientByIcn icn:" + icn);
						patient = fedCredSsoUtil.findPatientByIcn(icn, response);
						if (patient != null) {
							fedCredSsoUtil.logInfo(logger, "patient != null icn:" + icn);
							uProfile = patient.getUserProfile();

							// Discussion with Carnetta: 3/26/2015 Check for the
							// SSN. If SSN is different,
							// then display the error message and take him out
							if (fedCredSsoUtil.isSsnValid(ssn, idType)) {
								request.getSession().setAttribute(FedCredSsoUtil.ERROR_DETAIL,
									FedCredSsoUtil.INVALID_SSN_MSG);
								fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.INVALID_SSN_MSG);
								response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
								return;
							}

							response.sendRedirect(fedCredSsoUtil.getReauthPageUrl());
							return;
						}
					}
				}

				fedCredSsoUtil.logInfo(logger, "searchInMVIWithIcn icn:" + icn);
				// mviPatRes =
				// gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createMviIntegrationServiceDelegate().
				// searchPersonInMVIForUSAA(firstName, middleName, lastName,
				// birthDate, gender, ssn);
				ResponseUtil<PatientDTO> responseUtil = new ResponseUtil<PatientDTO>();
				fedCredSsoUtil.searchInMVIWithIcn(icn, response);
				
				if(responseUtil.isFailure()) {
					fedCredSsoUtil.logInfo(logger, "searchInMVIWithIcn Error Going to Error Page icn:" + icn);
					return;
				} 
				
				patient = responseUtil.getPojoObject();
				
				if(patient != null) {
					fedCredSsoUtil.logInfo(logger, "searchInMVIWithIcn Found record Going to Error Page icn:" + icn);
					response.sendRedirect(fedCredSsoUtil.getConnectePageUrl());
					return;
				}
			}
		} catch (Throwable t) {
			response.sendRedirect(fedCredSsoUtil.getConnectePageUrl());
			return;
		}
		
		if(uProfile == null) {
			fedCredSsoUtil.logInfo(logger, "searchInMVIWithIcn Found record Going to Error Page icn:" + icn);
			response.sendRedirect(fedCredSsoUtil.getAnonymousUrl());
			return;
		}
		
		InPersonAuthenticationDTO ipa = null; 
		
		patient = fedCredSsoUtil.getPatient(uProfile.getId());
		
		if(patient == null) {
			fedCredSsoUtil.logInfo(logger, "IPA not found for icn:" + icn);
			response.sendRedirect(fedCredSsoUtil.getAnonymousUrl());
			return;
		}
		
		if(patient.getIpas().iterator().hasNext()) {
			ipa = patient.getIpas().iterator().next();
		}
		
		if(ipa == null) {
			fedCredSsoUtil.logInfo(logger, "IPA not found for icn:" + icn);
			response.sendRedirect(fedCredSsoUtil.getAnonymousUrl());
			return;
		} else if(fedCredSsoUtil.isIpaAuthenticated(ipa)) {
			fedCredSsoUtil.logInfo(logger, "IPA is authenticated for icn:" + icn);
			fedCredSsoUtil.processFacilitiesUpdate(ipa.getPatient());
			fedCredSsoUtil.processLastLogin(ipa.getPatient().getUserProfile(), fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.CSID_PARAM));
			fedCredSsoUtil.determineDeepLinkingPage(response);
			return;
		} else {
			if(fedCredSsoUtil.goToOnlineAuthenticationPage(patient, request)) {
				fedCredSsoUtil.logInfo(logger, "Going to Online Authentication Page icn:" + icn);
				response.sendRedirect(fedCredSsoUtil.getOnlineAuthenticationUrl());
				return;
			} 
			fedCredSsoUtil.logInfo(logger, "Going to MHV Logged In Page icn:" + icn);
			response.sendRedirect(fedCredSsoUtil.getMHVLoggedInUrl());
			return;
		}
	}

	@Override
	public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		try {
			processFullTraitSSo(request, response);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			throw new ActionException();
		} catch (IOException e) {
			e.printStackTrace();
			throw new ActionException();
		}
	}
}
